<!DOCTYPE xsl:stylesheet  [
<!ENTITY ndash "&#8211;">
]>
<xsl:stylesheet version="1.0" 
	xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
	xmlns:m1="http://www.sec.gov/edgar/nmfp2"
	xmlns:ns3="http://www.sec.gov/edgar/nmfp2common">
	
	<xsl:template name="item2_partA">
		<h3>Part A: Series-Level Information about the Fund</h3>
		<table role="presentation">
			<tr>
				<td class="label"><b>Item A.1</b> Securities Act File Number.</td>
				<td>
					<div class="fakeBox2">
						<xsl:value-of select="string(m1:seriesLevelInfo/m1:securitiesActFileNumber)" />
					</div>
				</td>
			</tr>
			<xsl:for-each select="m1:seriesLevelInfo/m1:adviser">
				<tr>
					<td class="label"><b>Item A.2</b> Investment Adviser</td>
					<td>
						<div class="fakeBox3">
							<xsl:value-of select="m1:adviserName" />
						</div>					
					</td>
				</tr>
				<tr>
					<td class="label">
						<blockquote>
							a. SEC file number of investment adviser
						</blockquote>
					</td>
					<td>
						<div class="fakeBox2">
							<xsl:value-of select="m1:adviserFileNumber" />
						</div>
					</td>
				</tr>
			</xsl:for-each>

			<xsl:if test="count(m1:seriesLevelInfo/m1:subAdviser) &gt; 0">
				<xsl:for-each select="m1:seriesLevelInfo/m1:subAdviser">
					<tr>
						<td class="label">
							<b>Item A.3</b> Sub-Adviser. If a fund has one or more sub-advisers, disclose the name of each sub-adviser.
						</td>
						<td>
							<div class="fakeBox3">
								<xsl:value-of select="m1:adviserName" />
							</div>								
						</td>
					</tr>
					<tr>
						<td class="label">
							<blockquote>
								a. SEC file number of sub-adviser
							</blockquote>
						</td>
						<td>
							<div class="fakeBox2">
								<xsl:value-of select="m1:adviserFileNumber" />
							</div>
						</td>
					</tr>
				</xsl:for-each>
			</xsl:if>
			<tr>
				<td class="label"><b>Item A.4</b> Independent Public Accountant.</td>
				<td>
					<div class="fakeBox3">
						<xsl:value-of select="string(m1:seriesLevelInfo/m1:indpPubAccountant/m1:name)" />
					</div>					
				</td>
			</tr>
			<tr>
				<td class="label">
					<blockquote>
						a. City and state of independent public accountant.
					</blockquote>
				</td>
				<td></td>
			</tr>
			<tr>
				<td class="label">
					<blockquote>
						<blockquote>
							City of independent public accountant
						</blockquote>
					</blockquote>
				</td>
				<td>
					<div class="fakeBox">
						<xsl:value-of select="string(m1:seriesLevelInfo/m1:indpPubAccountant/m1:city)" />
					</div>
				</td>
			</tr>
			<tr>
				<td class="label">
					<blockquote>
						<blockquote>
							State/Province/Country of independent public accountant
						</blockquote>
					</blockquote>
				</td>
				<td>
					<div class="fakeBox">
						<xsl:call-template name="stateDescription">
							<xsl:with-param name="stateCode"
							select="string(m1:seriesLevelInfo/m1:indpPubAccountant/m1:stateCountry)" />
						</xsl:call-template>
					</div>
				</td>
			</tr>		
			<xsl:for-each select="m1:seriesLevelInfo/m1:administrator">
				<tr>
					<td class="label">
						<b>Item A.5</b> Administrator. If a fund has one or more administrators, disclose the name of each administrator.
					</td>
					<td>
						<div class="fakeBox3">
							<xsl:value-of select="m1:administratorName" />
						</div>
					</td>
				</tr>
			</xsl:for-each>	
			<xsl:for-each select="m1:seriesLevelInfo/m1:transferAgent">
				<tr>
					<td class="label"><b>Item A.6</b> Transfer Agent.</td>
					<td>
						<div class="fakeBox3">
							<xsl:value-of select="m1:name" />
						</div>
					</td>
				</tr>
				<xsl:if test="count(m1:cik) &gt; 0">
					<tr>
						<td class="label">
							<blockquote>
								a. CIK Number
							</blockquote>
						</td>
						<td>
							<div class="fakeBox2">
								<xsl:value-of select="m1:cik" />
							</div>					
						</td>
					</tr>
					<tr>
						<td class="label">
							<blockquote>
								b. SEC file number of transfer agent.
							</blockquote>
						</td>
						<td>
							<div class="fakeBox2">
								<xsl:value-of select="m1:fileNumber" />
							</div>					
						</td>
					</tr>
				</xsl:if>
			</xsl:for-each>
			<tr>
				<td class="label">
					<b>Item A.7</b> Master-Feeder Funds. Is this a Feeder Fund? If Yes, answer Items A.7.a - 7.c.
				</td>
				<td>
					<xsl:choose>
						<xsl:when test="string(m1:seriesLevelInfo/m1:feederFundFlag)='Y'">
							<img src="Images/radio-checked.jpg" alt="Radio button checked"/> Yes
						</xsl:when>
						<xsl:otherwise>
							<img src="Images/radio-unchecked.jpg" alt="Radio button not checked"/> Yes
						</xsl:otherwise>
					</xsl:choose> &#160;
					<xsl:choose>
						<xsl:when test="string(m1:seriesLevelInfo/m1:feederFundFlag)='N'">
							<img src="Images/radio-checked.jpg" alt="Radio button checked"/> No
						</xsl:when>
						<xsl:otherwise>
							<img src="Images/radio-unchecked.jpg" alt="Radio button not checked"/> No
						</xsl:otherwise>
					</xsl:choose>					
				</td>
			</tr>
			
			<tr>
				<td class="label">
					<blockquote>
						a. Identify the Master Fund by CIK or, if the fund does not have a CIK, by name.
					</blockquote>
				</td>
				<td></td>
			</tr>
			<xsl:if test="string(m1:seriesLevelInfo/m1:feederFundFlag) = 'Y'">
				<tr>
					<td class="label">
						<blockquote>
							<blockquote>
								CIK of the Master Fund
							</blockquote>
						</blockquote>
					</td>
					<td>
						<div class="fakeBox2">
							<xsl:value-of select="string(m1:seriesLevelInfo/m1:masterFeederFund/m1:cik)" />
						</div>					
					</td>
				</tr>
				<tr>
					<td class="label">
						<blockquote>
							<blockquote>
								Name of the Master Fund
							</blockquote>
						</blockquote>
					</td>
					<td>
						<div class="fakeBox3">
							<xsl:value-of select="string(m1:seriesLevelInfo/m1:masterFeederFund/m1:name)" />
						</div>					
					</td>					
				</tr>
				<tr>
					<td class="label">
						<blockquote>
							b. Securities Act file number of the Master Fund.
						</blockquote>
					</td>
					<td>
						<div class="fakeBox2">	
							<xsl:value-of select="string(m1:seriesLevelInfo/m1:masterFeederFund/m1:fileNumber)" />
						</div>
					</td>
				</tr>
				<xsl:if test="count(m1:seriesLevelInfo/m1:masterFeederFund/m1:cik) &gt; 0">
					<tr>
						<td class="label">
							<blockquote>
								c. EDGAR series identifier of the Master Fund.
							</blockquote>
						</td>
						<td>
							<div class="fakeBox2">	
								<xsl:value-of select="m1:seriesLevelInfo/m1:masterFeederFund/m1:seriesId" />
							</div>	
						</td>
					</tr>
				</xsl:if>
			</xsl:if>		
			<tr>
				<td class="label">
					<b>Item A.8</b> Master-Feeder Funds. Is this a Master Fund? If Yes, answer Items A.8.a - 8.c.
				</td>
				<td>
					<xsl:choose>
						<xsl:when test="string(m1:seriesLevelInfo/m1:masterFundFlag)='Y'">
							<img src="Images/radio-checked.jpg" alt="Radio button checked"/> Yes
						</xsl:when>
						<xsl:otherwise>
							<img src="Images/radio-unchecked.jpg" alt="Radio button not checked"/> Yes
						</xsl:otherwise>
					</xsl:choose> &#160;
					<xsl:choose>
						<xsl:when test="string(m1:seriesLevelInfo/m1:masterFundFlag)='N'">
							<img src="Images/radio-checked.jpg" alt="Radio button checked"/> No
						</xsl:when>
						<xsl:otherwise>
							<img src="Images/radio-unchecked.jpg" alt="Radio button not checked"/> No
						</xsl:otherwise>
					</xsl:choose>					
				</td>
			</tr>
			
			<xsl:if test="$masterFundFlagYesNo = 'Y'">
				<xsl:for-each select="m1:seriesLevelInfo/m1:feederFund">
					<tr>
						<td class="label">
							<blockquote>
								a. Identify all Feeder Funds by CIK or, if the fund does not have a CIK, by name.
							</blockquote>
						</td>
						<td>
						</td>
					</tr>
					<xsl:if test="count(m1:cik) &gt; 0">
						<tr>
							<td class="label"><blockquote><blockquote>CIK of the Feeder Fund</blockquote></blockquote></td>
							<td>
								<div class="fakeBox2">
									<xsl:value-of select="m1:cik" />
								</div>
							</td>										
						</tr>
					</xsl:if>
					<xsl:if test="count(m1:name) &gt; 0">
						<tr>
							<td class="label"><blockquote><blockquote>Name of the Feeder Fund</blockquote></blockquote></td>
							<td>
								<div class="fakeBox3">	
									<xsl:value-of select="m1:name" />
								</div>
							</td>					
						</tr>
					</xsl:if>
					<xsl:if test="$masterFundFlagYesNo = 'Y'">
						<tr>
							<td class="label"><blockquote>b. Securities Act file number of each Feeder Fund.</blockquote></td>
							<td>
								<div class="fakeBox2">	
									<xsl:value-of select="string(m1:fileNumber)" />
								</div>
							</td>
						</tr>
					</xsl:if>
					<xsl:if test="count(m1:cik) &gt; 0">
						<tr>
							<td class="label"><blockquote>c. EDGAR series identifier of each Feeder Fund.</blockquote></td>
							<td>
								<div class="fakeBox2">	
									<xsl:value-of select="m1:seriesId" />
								</div>
							</td>										
						</tr>
					</xsl:if>
				</xsl:for-each>
			</xsl:if>
			<tr>
				<td class="label"><b>Item A.9</b> Is this series primarily used to fund insurance company separate accounts?</td>
				<td>
					<xsl:choose>
						<xsl:when test="string(m1:seriesLevelInfo/m1:seriesFundInsuCmpnySepAccntFlag) = 'Y'">
							<img src="Images/radio-checked.jpg" alt="Radio button checked"/> Yes
						</xsl:when>
						<xsl:otherwise>
							<img src="Images/radio-unchecked.jpg" alt="Radio button not checked"/> Yes
						</xsl:otherwise>
					</xsl:choose> &#160;
					<xsl:choose>
						<xsl:when test="string(m1:seriesLevelInfo/m1:seriesFundInsuCmpnySepAccntFlag) = 'N'">
							<img src="Images/radio-checked.jpg" alt="Radio button checked"/> No
						</xsl:when>
						<xsl:otherwise>
							<img src="Images/radio-unchecked.jpg" alt="Radio button not checked"/> No
						</xsl:otherwise>
					</xsl:choose>					
				</td>				
			</tr>
			<tr>
				<td class="label">
					<b>Item A.10</b> Category. Indicate the category that identifies the money market fund from among the following:
				</td>
				<!-- VARIABLES BEGIN -->
				<!-- 1. -->
				<xsl:variable name="marketFund1">
					<xsl:for-each select="m1:seriesLevelInfo/m1:moneyMarketFundCategory">
						<xsl:if test="contains(. , 'Treasury')">
							<xsl:value-of select="."/>
						</xsl:if>
					</xsl:for-each>
				</xsl:variable>
				<!-- 2. -->
				<xsl:variable name="marketFund2">
					<xsl:for-each select="m1:seriesLevelInfo/m1:moneyMarketFundCategory">
						<xsl:if test="contains(. , 'Government/Agency')">
							<xsl:value-of select="."/>
						</xsl:if>
					</xsl:for-each>
				</xsl:variable>
				<!-- 3. -->
				<xsl:variable name="marketFund3">
					<xsl:for-each select="m1:seriesLevelInfo/m1:moneyMarketFundCategory">
						<xsl:if test="contains(. , 'Exempt Government')">
							<xsl:value-of select="."/>
						</xsl:if>
					</xsl:for-each>
				</xsl:variable>
				<!-- 4. -->
				<xsl:variable name="marketFund4">
					<xsl:for-each select="m1:seriesLevelInfo/m1:moneyMarketFundCategory">
						<xsl:if test="contains(. , 'Prime')">
							<xsl:value-of select="."/>
						</xsl:if>
					</xsl:for-each>
				</xsl:variable>
				<!-- 5. -->
				<xsl:variable name="marketFund5">
					<xsl:for-each select="m1:seriesLevelInfo/m1:moneyMarketFundCategory">
						<xsl:if test="contains(. , 'Single State')">
							<xsl:value-of select="."/>
						</xsl:if>
					</xsl:for-each>
				</xsl:variable>
				<!-- 6. -->
				<xsl:variable name="marketFund6">
					<xsl:for-each select="m1:seriesLevelInfo/m1:moneyMarketFundCategory">
						<xsl:if test="contains(. , 'Other Tax Exempt')">
							<xsl:value-of select="."/>
						</xsl:if>
					</xsl:for-each>
				</xsl:variable>
			<!-- VARIABLES END -->

				<td>
					<xsl:choose>
						<xsl:when test="$marketFund1 = 'Treasury'">
							<img src="Images/box-checked.jpg" alt="Checkbox checked" />
						</xsl:when>
						<xsl:otherwise>
							<img src="Images/box-unchecked.jpg" alt="Checkbox not checked" />
						</xsl:otherwise>
					</xsl:choose>&#160;Treasury<br/>
					<xsl:choose>
						<xsl:when test="$marketFund2 = 'Government/Agency'">
							<img src="Images/box-checked.jpg" alt="Checkbox checked" />
						</xsl:when>
						<xsl:otherwise>
							<img src="Images/box-unchecked.jpg" alt="Checkbox not checked" />
						</xsl:otherwise>
					</xsl:choose>&#160;Government/Agency<br/>
					<xsl:choose>
						<xsl:when test="$marketFund3 = 'Exempt Government'">
							<img src="Images/box-checked.jpg" alt="Checkbox checked" />
						</xsl:when>
						<xsl:otherwise>
							<img src="Images/box-unchecked.jpg" alt="Checkbox not checked" />
						</xsl:otherwise>
					</xsl:choose>&#160;Exempt Government<br/>		
					<xsl:choose>
						<xsl:when test="$marketFund4 = 'Prime'">
							<img src="Images/box-checked.jpg" alt="Checkbox checked" />
						</xsl:when>
						<xsl:otherwise>
							<img src="Images/box-unchecked.jpg" alt="Checkbox not checked" />
						</xsl:otherwise>
					</xsl:choose>&#160;Prime<br/>
					<xsl:choose>
						<xsl:when test="$marketFund5 = 'Single State'">
							<img src="Images/box-checked.jpg" alt="Checkbox checked" />
						</xsl:when>
						<xsl:otherwise>
							<img src="Images/box-unchecked.jpg" alt="Checkbox not checked" />
						</xsl:otherwise>
					</xsl:choose>&#160;Single State<br/>
					<xsl:choose>
						<xsl:when test="$marketFund6 = 'Other Tax Exempt'">
							<img src="Images/box-checked.jpg" alt="Checkbox checked" />
						</xsl:when>
						<xsl:otherwise>
							<img src="Images/box-unchecked.jpg" alt="Checkbox not checked" />
						</xsl:otherwise>
					</xsl:choose>&#160;Other Tax Exempt<br/>							
				</td>
			</tr>
			<tr>
				<td class="label">
					<blockquote>
						a. Is this fund an exempt retail fund as defined in 270.2a-7(a)(25)?
					</blockquote>
				</td>
				<td>
					<xsl:choose>
						<xsl:when 
							test="string(m1:seriesLevelInfo/m1:fundExemptRetailFlag) = 'Y'">
							<img src="Images/radio-checked.jpg" alt="Radio button checked"/> Yes
						</xsl:when>
						<xsl:otherwise>
							<img src="Images/radio-unchecked.jpg" alt="Radio button not checked"/> Yes
						</xsl:otherwise>
					</xsl:choose> &#160;
					<xsl:choose>
						<xsl:when 
							test="string(m1:seriesLevelInfo/m1:fundExemptRetailFlag) = 'N'">
							<img src="Images/radio-checked.jpg" alt="Radio button checked"/> No
						</xsl:when>
						<xsl:otherwise>
							<img src="Images/radio-unchecked.jpg" alt="Radio button not checked"/> No
						</xsl:otherwise>
					</xsl:choose>					
				</td>
			</tr>
			<tr >
				<td class="label"><b>Item A.11</b> Dollar-weighted average portfolio maturity ("WAM" as defined in rule 2a-7(d)(1)(ii)).</td>
				<td>
					<div class="fakeBox2">
						<xsl:value-of select="string(m1:seriesLevelInfo/m1:averagePortfolioMaturity)" />
					</div>				
				</td>
			</tr>
			<tr>
				<td class="label"><b>Item A.12</b> Dollar-weighted average life maturity ("WAL" as defined in rule 2a-7(d)(1)(iii)). 
					Calculate WAL without reference to the exceptions in rule 2a-7(d) regarding interest rate readjustments.</td>
				<td>
					<div class="fakeBox2">
						<xsl:value-of select="string(m1:seriesLevelInfo/m1:averageLifeMaturity)" />
					</div>										
				</td>
			</tr>
			<tr> 
				<td class="label">
					<b>Item A.13</b> Liquidity. Provide the following, as of the close of business on each Friday during the month reported (if the reporting date falls on a holiday or other day on which the fund does not calculate the daily or weekly liquidity, provide the value as of the close of business on the date in that week last calculated):
				</td>
				<td>
				</td>
			</tr>
			<tr >
				<td class="label">
					<blockquote>
						a. Total Value of Daily Liquid Assets to the nearest cent:
					</blockquote>
				</td>
				<td></td>
			</tr>
			<tr>
				<td class="label">
					<blockquote>
						<blockquote>
							i. Friday, day 1:
						</blockquote>
					</blockquote>
				</td>
				<td>
					<div class="fakeBox2">
						<xsl:if test="string(m1:seriesLevelInfo/m1:totalValueDailyLiquidAssets/ns3:fridayDay1) &gt;= 0">
							<xsl:value-of select='format-number(m1:seriesLevelInfo/m1:totalValueDailyLiquidAssets/ns3:fridayDay1, "$###,###,###,##0.00")' />
						</xsl:if>
					</div>				
				</td>
			</tr>
			<tr>
				<td class="label">
					<blockquote>
						<blockquote>
							ii. Friday, day 2:
						</blockquote>
					</blockquote>
				</td>
				<td>
					<div class="fakeBox2">
						<xsl:if test="string(m1:seriesLevelInfo/m1:totalValueDailyLiquidAssets/ns3:fridayDay2) &gt;= 0">
							<xsl:value-of select='format-number(m1:seriesLevelInfo/m1:totalValueDailyLiquidAssets/ns3:fridayDay2, "$###,###,###,##0.00")' />
						</xsl:if>
					</div>				
				</td>
			</tr>
			<tr>
				<td class="label">
					<blockquote>
						<blockquote>
							iii. Friday, day 3:
						</blockquote>
					</blockquote>
				</td>
				<td>
					<div class="fakeBox2">
						<xsl:if test="string(m1:seriesLevelInfo/m1:totalValueDailyLiquidAssets/ns3:fridayDay3) &gt;= 0">
							<xsl:value-of select='format-number(m1:seriesLevelInfo/m1:totalValueDailyLiquidAssets/ns3:fridayDay3, "$###,###,###,##0.00")' />
						</xsl:if>
					</div>				
				</td>
			</tr>
			<tr>
				<td class="label">
					<blockquote>
						<blockquote>
							iv. Friday, day 4:
						</blockquote>
					</blockquote>
				</td>
				<td>
					<div class="fakeBox2">
						<xsl:if test="string(m1:seriesLevelInfo/m1:totalValueDailyLiquidAssets/ns3:fridayDay4) &gt;= 0">
							<xsl:value-of select='format-number(m1:seriesLevelInfo/m1:totalValueDailyLiquidAssets/ns3:fridayDay4, "$###,###,###,##0.00")' />
						</xsl:if>
					</div>
				</td>
			</tr>
			<tr>
				<td class="label">
					<blockquote>
						<blockquote>
							v. Friday, day 5 (if applicable):
						</blockquote>
					</blockquote>
				</td>
				<td>
					<div class="fakeBox2">
						<xsl:if test="string(m1:seriesLevelInfo/m1:totalValueDailyLiquidAssets/ns3:fridayDay5) &gt;= 0">
							<xsl:value-of select='format-number(m1:seriesLevelInfo/m1:totalValueDailyLiquidAssets/ns3:fridayDay5, "$###,###,###,##0.00")' />
						</xsl:if>
					</div>
				</td>
			</tr>
			<tr>
				<td class="label">
					<blockquote>
						b. Total Value of Weekly Liquid Assets (including Daily Liquid Assets) to the nearest cent:
					</blockquote>
				</td>
				<td></td>
			</tr>
			<tr>
				<td class="label">
					<blockquote>
						<blockquote>
							i. Friday, week 1:
						</blockquote>
					</blockquote>
				</td>
				<td>
					<div class="fakeBox2">
						<xsl:if test="count(m1:seriesLevelInfo/m1:totalValueWeeklyLiquidAssets/ns3:fridayWeek1) &gt; 0">
							<xsl:value-of select='format-number(m1:seriesLevelInfo/m1:totalValueWeeklyLiquidAssets/ns3:fridayWeek1, "$###,###,###,##0.00")' />
						</xsl:if>
					</div>				
				</td>
			</tr>
			<tr>
				<td class="label">
					<blockquote>
						<blockquote>
							ii. Friday, week 2:
						</blockquote>
					</blockquote>
				</td>
				<td>
					<div class="fakeBox2">
						<xsl:if test="count(m1:seriesLevelInfo/m1:totalValueWeeklyLiquidAssets/ns3:fridayWeek2) &gt; 0">
							<xsl:value-of select='format-number(m1:seriesLevelInfo/m1:totalValueWeeklyLiquidAssets/ns3:fridayWeek2, "$###,###,###,##0.00")' />
						</xsl:if>
					</div>				
				</td>
			</tr>
			<tr>
				<td class="label">
					<blockquote>
						<blockquote>
							iii. Friday, week 3:
						</blockquote>
					</blockquote>
				</td>
				<td>
					<div class="fakeBox2">
						<xsl:if test="count(m1:seriesLevelInfo/m1:totalValueWeeklyLiquidAssets/ns3:fridayWeek3) &gt; 0">
							<xsl:value-of select='format-number(m1:seriesLevelInfo/m1:totalValueWeeklyLiquidAssets/ns3:fridayWeek3, "$###,###,###,##0.00")' />
						</xsl:if>
					</div>				
				</td>
			</tr>
			<tr>
				<td class="label">
					<blockquote>
						<blockquote>
							iv. Friday, week 4:
						</blockquote>
					</blockquote>
				</td>
				<td>
					<div class="fakeBox2">
						<xsl:if test="count(m1:seriesLevelInfo/m1:totalValueWeeklyLiquidAssets/ns3:fridayWeek4) &gt; 0">
							<xsl:value-of select='format-number(m1:seriesLevelInfo/m1:totalValueWeeklyLiquidAssets/ns3:fridayWeek4, "$###,###,###,##0.00")' />
						</xsl:if>
					</div>
				</td>
			</tr>
			<tr>
				<td class="label">
					<blockquote>
						<blockquote>
							v. Friday, week 5 (if applicable):
						</blockquote>
					</blockquote>
				</td>
				<td>
					<div class="fakeBox2">
						<xsl:if test="string(m1:seriesLevelInfo/m1:totalValueWeeklyLiquidAssets/ns3:fridayWeek5) &gt;= 0">
							<xsl:value-of select='format-number(m1:seriesLevelInfo/m1:totalValueWeeklyLiquidAssets/ns3:fridayWeek5, "$###,###,###,##0.00")' />
						</xsl:if>
					</div>
				</td>
			</tr>
			<tr>
				<td class="label">
					<blockquote>
						c. Percentage of Total Assets invested in Daily Liquid Assets:
					</blockquote>
				</td>
				<td></td>
			</tr>
			<tr>
				<td class="label">
					<blockquote>
						<blockquote>
							i. Friday, day 1:
						</blockquote>
					</blockquote>
				</td>
				<td>
					<div class="fakeBox2">
						<xsl:if test="string(m1:seriesLevelInfo/m1:percentageDailyLiquidAssets/ns3:fridayDay1) &gt;= 0">
							<xsl:variable name="dailyWeek1" select='format-number(m1:seriesLevelInfo/m1:percentageDailyLiquidAssets/ns3:fridayDay1 ,  "0.0000", "percentage")' />
							<xsl:value-of select='format-number(100 * $dailyWeek1 , "dd0.00", "percentage")' />%
						</xsl:if>
					</div>				
				</td>
			</tr>
			<tr>
				<td class="label">
					<blockquote>
						<blockquote>
							ii. Friday, day 2:
						</blockquote>
					</blockquote>
				</td>
				<td>
					<div class="fakeBox2">
						<xsl:if test="string(m1:seriesLevelInfo/m1:percentageDailyLiquidAssets/ns3:fridayDay2) &gt;= 0">
							<xsl:variable name="dailyWeek2" select='format-number(m1:seriesLevelInfo/m1:percentageDailyLiquidAssets/ns3:fridayDay2 ,  "0.0000", "percentage")' />
							<xsl:value-of select='format-number(100 * $dailyWeek2 , "dd0.00", "percentage")' />%
						</xsl:if>
					</div>				
				</td>
			</tr>
			<tr>
				<td class="label">
					<blockquote>
						<blockquote>
							iii. Friday, day 3:
						</blockquote>
					</blockquote>
				</td>
				<td>
					<div class="fakeBox2">
						<xsl:if test="string(m1:seriesLevelInfo/m1:percentageDailyLiquidAssets/ns3:fridayDay3) &gt;= 0">
							<xsl:variable name="dailyWeek3" select='format-number(m1:seriesLevelInfo/m1:percentageDailyLiquidAssets/ns3:fridayDay3 ,  "0.0000", "percentage")' />
							<xsl:value-of select='format-number(100 * $dailyWeek3 , "dd0.00", "percentage")' />%
						</xsl:if>
					</div>				
				</td>
			</tr>
			<tr>
				<td class="label">
					<blockquote>
						<blockquote>
							iv. Friday, day 4:
						</blockquote>
					</blockquote>
				</td>
				<td>
					<div class="fakeBox2">
						<xsl:if test="string(m1:seriesLevelInfo/m1:percentageDailyLiquidAssets/ns3:fridayDay4) &gt;= 0">
							<xsl:variable name="dailyWeek4" select='format-number(m1:seriesLevelInfo/m1:percentageDailyLiquidAssets/ns3:fridayDay4 ,  "0.0000", "percentage")' />
							<xsl:value-of select='format-number(100 * $dailyWeek4 , "dd0.00", "percentage")' />%
						</xsl:if>
					</div>
				</td>
			</tr>
			<tr>
				<td class="label">
					<blockquote>
						<blockquote>
							v. Friday, day 5 (if applicable):
						</blockquote>
					</blockquote>
				</td>
				<td>
					<div class="fakeBox2">
						<xsl:if test="string(m1:seriesLevelInfo/m1:percentageDailyLiquidAssets/ns3:fridayDay5) &gt;= 0">
							<xsl:variable name="dailyWeek5" select='format-number(m1:seriesLevelInfo/m1:percentageDailyLiquidAssets/ns3:fridayDay5 ,  "0.0000", "percentage")' />
							<xsl:value-of select='format-number(100 * $dailyWeek5 , "dd0.00", "percentage")' />%
						</xsl:if>
					</div>
				</td>
			</tr>
			<tr>
				<td class="label">
					<blockquote>
						d. Percentage of Total Assets invested in Weekly Liquid Assets (including Daily Liquid Assets):
					</blockquote>
				</td>
				<td></td>
			</tr>
			<tr>
				<td class="label">
					<blockquote>
						<blockquote>
							i. Friday, week 1:
						</blockquote>
					</blockquote>
				</td>
				<td>
					<div class="fakeBox2">
						<xsl:if test="string(m1:seriesLevelInfo/m1:percentageWeeklyLiquidAssets/ns3:fridayWeek1) &gt;= 0">
							<xsl:variable name="weeklyWeek1" select='format-number(m1:seriesLevelInfo/m1:percentageWeeklyLiquidAssets/ns3:fridayWeek1 ,  "0.0000", "percentage")' />
							<xsl:value-of select='format-number(100 * $weeklyWeek1 ,  "dd0.00", "percentage")' />%
						</xsl:if>
					</div>				
				</td>
			</tr>
			<tr>
				<td class="label">
					<blockquote>
						<blockquote>
							ii. Friday, week 2:
						</blockquote>
					</blockquote>
				</td>
				<td>
					<div class="fakeBox2">
						<xsl:if test="string(m1:seriesLevelInfo/m1:percentageWeeklyLiquidAssets/ns3:fridayWeek2) &gt;= 0">
							<xsl:variable name="weeklyWeek2" select='format-number(m1:seriesLevelInfo/m1:percentageWeeklyLiquidAssets/ns3:fridayWeek2 ,  "0.0000", "percentage")' />
							<xsl:value-of select='format-number(100 * $weeklyWeek2 ,  "dd0.00", "percentage")' />%
						</xsl:if>
					</div>				
				</td>
			</tr>
			<tr>
				<td class="label">
					<blockquote>
						<blockquote>
							iii. Friday, week 3:
						</blockquote>
					</blockquote>
				</td>
				<td>
					<div class="fakeBox2">
						<xsl:if test="string(m1:seriesLevelInfo/m1:percentageWeeklyLiquidAssets/ns3:fridayWeek3) &gt;= 0">
							<xsl:variable name="weeklyWeek3" select='format-number(m1:seriesLevelInfo/m1:percentageWeeklyLiquidAssets/ns3:fridayWeek3 ,  "0.0000", "percentage")' />
							<xsl:value-of select='format-number(100 * $weeklyWeek3 ,  "dd0.00", "percentage")' />%
						</xsl:if>
					</div>				
				</td>
			</tr>
			<tr>
				<td class="label">
					<blockquote>
						<blockquote>
							iv. Friday, week 4:
						</blockquote>
					</blockquote>
				</td>
				<td>
					<div class="fakeBox2">
						<xsl:if test="string(m1:seriesLevelInfo/m1:percentageWeeklyLiquidAssets/ns3:fridayWeek4) &gt;= 0">
							<xsl:variable name="weeklyWeek4" select='format-number(m1:seriesLevelInfo/m1:percentageWeeklyLiquidAssets/ns3:fridayWeek4 ,  "0.0000", "percentage")' />
							<xsl:value-of select='format-number(100 * $weeklyWeek4 ,  "dd0.00", "percentage")' />%
						</xsl:if>
					</div>
				</td>
			</tr>
			<tr>
				<td class="label">
					<blockquote>
						<blockquote>
							v. Friday, week 5 (if applicable):
						</blockquote>
					</blockquote>
				</td>
				<td>
					<div class="fakeBox2">
						<xsl:if test="string(m1:seriesLevelInfo/m1:percentageWeeklyLiquidAssets/ns3:fridayWeek5) &gt;= 0">
							<xsl:variable name="weeklyWeek5" select='format-number(m1:seriesLevelInfo/m1:percentageWeeklyLiquidAssets/ns3:fridayWeek5 ,  "0.0000", "percentage")' />
							<xsl:value-of select='format-number(100 * $weeklyWeek5 ,  "dd0.00", "percentage")' />%
						</xsl:if>
					</div>
				</td>
			</tr>
			<tr>
				<td class="label">
					<b>Item A.14</b> Provide the following, to the nearest cent:
				</td>
				<td></td>
			</tr>
			<tr>
				<td class="label">
					<blockquote>
						a. Cash. (See General Instructions E.)
					</blockquote>
				</td>
				<td>
					<div class="fakeBox2">
						<xsl:if test="count(m1:seriesLevelInfo/m1:cash) &gt; 0">
							<xsl:value-of select='format-number(m1:seriesLevelInfo/m1:cash, "$###,##0.00")' />
						</xsl:if>
					</div>				
				</td>
			</tr>
			
			<tr>
				<td class="label">
					<blockquote>
						b. Total Value of portfolio securities. (See General Instructions E.)
					</blockquote>
				</td>
				<td>
					<div class="fakeBox2">
						<xsl:if test="count(m1:seriesLevelInfo/m1:totalValuePortfolioSecurities) &gt; 0">
							<xsl:value-of select='format-number(m1:seriesLevelInfo/m1:totalValuePortfolioSecurities, "$###,###,###,##0.00")' />
						</xsl:if>
					</div>				
				</td>
			</tr>			
			<tr>
				<td class="label">
					<blockquote>
						<blockquote>
							i. If any portfolio securities are valued using amortized cost, the total value of the portfolio securities valued at amortized cost.
						</blockquote>
					</blockquote>
				</td>
				<td>
					<div class="fakeBox2">
						<xsl:if test="count(m1:seriesLevelInfo/m1:amortizedCostPortfolioSecurities) &gt; 0">
							<xsl:value-of select='format-number(m1:seriesLevelInfo/m1:amortizedCostPortfolioSecurities, "$###,###,###,##0.00")' />
						</xsl:if>
					</div>				
				</td>
			</tr>
			<tr>
				<td class="label">
					<blockquote>
						c. Total Value of other assets (excluding amounts provided in A.14.a-c.)
					</blockquote>
				</td>
				<td>
					<div class="fakeBox2">
						<xsl:if test="count(m1:seriesLevelInfo/m1:totalValueOtherAssets) &gt; 0">
							<xsl:value-of select='format-number(m1:seriesLevelInfo/m1:totalValueOtherAssets, "$###,###,###,##0.00")' />
						</xsl:if>
					</div>				
				</td>
			</tr>
			<tr>
				<td class="label"><b>Item A.15</b> Total value of liabilities, to the nearest cent.</td>
				<td>
					<div class="fakeBox2">
						<xsl:if test="count(m1:seriesLevelInfo/m1:totalValueLiabilities) &gt; 0">
							<xsl:value-of select='format-number(m1:seriesLevelInfo/m1:totalValueLiabilities, "$###,###,###,##0.00")' />
						</xsl:if>
					</div>									
				</td>
			</tr>
			<tr>
				<td class="label"><b>Item A.16</b> Net assets of the series, to the nearest cent.</td>
				<td>
					<div class="fakeBox2">
						<xsl:if test="count(m1:seriesLevelInfo/m1:netAssetOfSeries) &gt; 0">
							<xsl:value-of select='format-number(m1:seriesLevelInfo/m1:netAssetOfSeries, "$###,###,###,##0.00")' />
						</xsl:if>
					</div>									
				</td>
			</tr>		
			<tr>
				<td class="label"><b>Item A.17</b> Number of shares outstanding, to the nearest hundredth.</td>
				<td>
					<div class="fakeBox2">
						<xsl:if test="count(m1:seriesLevelInfo/m1:numberOfSharesOutstanding) &gt; 0">
							$<xsl:value-of select='format-number(m1:seriesLevelInfo/m1:numberOfSharesOutstanding ,  "ddd,ddd,ddd,dd0.00dd", "percentage")' />
						</xsl:if>
					</div>									
				</td>
			</tr>	
			<tr>
				<td class="label"><b>Item A.18</b> If the fund seeks to maintain a stable price per share, state the price the fund seeks to maintain.</td>
				<td>
					<div class="fakeBox2">
						<xsl:if test="string(m1:seriesLevelInfo/m1:stablePricePerShare) &gt;= 0">
							<xsl:value-of select='format-number(m1:seriesLevelInfo/m1:stablePricePerShare, "$#,##0.0000")' />
						</xsl:if>	
					</div>									
				</td>
			</tr>
			<tr>
				<td class="label"><b>Item A.19</b> 7-day gross yield.  Based on the 7 days ended on the last day of the prior month, calculate the fund's yield by determining the net change, exclusive of capital changes and income other than investment income, in the value of a hypothetical pre-existing account having a balance of one share at the beginning of the period and dividing the difference by the value of the account at the beginning of the base period to obtain the base period return, and then multiplying the base period return by (365/7) with the resulting yield figure carried to the nearest hundredth of one percent.  The 7-day gross yield should not reflect a deduction of shareholders fees and fund operating expenses.  For master funds and feeder funds, report the 7-day gross yield at the master-fund level.</td>
				<td>
					<div class="fakeBox2">
						<xsl:if test="string(m1:seriesLevelInfo/m1:sevenDayGrossYield) &gt;= -1.9999">
							<xsl:variable name="sevenDayGrossYield" select='format-number(m1:seriesLevelInfo/m1:sevenDayGrossYield , "0.0000", "percentage")'/>
							<xsl:value-of select='format-number(100 * $sevenDayGrossYield ,  "dd0.00", "percentage")' />%							
						</xsl:if>
					</div>									
				</td>
			</tr>		
			<tr>
				<td class="label">
					<b>Item A.20</b> Net asset value per share.  Provide the net asset value per share, calculated using available market quotations (or an appropriate substitute that reflects current market conditions) rounded to the fourth decimal place in the case of a fund with a $1.0000 share price (or an equivalent level of accuracy for funds with a different share price), as of the close of business on each Friday during the month reported (if the reporting date falls on a holiday or other day on which the fund does not calculate the net asset value per share, provide the value as of the close of business on the date in that week last calculated):
				</td>
				<td>
				</td>
			</tr>
			<tr>
				<td class="label">
					<blockquote>
						i. Friday, week 1:
					</blockquote>
				</td>
				<td>
					<div class="fakeBox2">
						<xsl:if test="count(m1:seriesLevelInfo/m1:netAssetValue/ns3:fridayWeek1) &gt; 0">
							<xsl:value-of select='format-number(m1:seriesLevelInfo/m1:netAssetValue/ns3:fridayWeek1, "$#,##0.0000")' />
						</xsl:if>
					</div>									
				</td>
			</tr>
			<tr>
				<td class="label">
					<blockquote>
						ii. Friday, week 2:
					</blockquote>
				</td>
				<td>
					<div class="fakeBox2">
						<xsl:if test="count(m1:seriesLevelInfo/m1:netAssetValue/ns3:fridayWeek2) &gt; 0">
							<xsl:value-of select='format-number(m1:seriesLevelInfo/m1:netAssetValue/ns3:fridayWeek2, "$#,##0.0000")' />
						</xsl:if>
					</div>									
				</td>
			</tr>
			<tr>
				<td class="label">
					<blockquote>
						iii. Friday, week 3:
					</blockquote>
				</td>	
				<td>
					<div class="fakeBox2">
						<xsl:if test="count(m1:seriesLevelInfo/m1:netAssetValue/ns3:fridayWeek3) &gt; 0">
							<xsl:value-of select='format-number(m1:seriesLevelInfo/m1:netAssetValue/ns3:fridayWeek3, "$#,##0.0000")' />
						</xsl:if>
					</div>									
				</td>
			</tr>
			<tr>
				<td class="label">
					<blockquote>
						iv. Friday, week 4:
					</blockquote>
				</td>
				<td>
					<div class="fakeBox2">
						<xsl:if test="count(m1:seriesLevelInfo/m1:netAssetValue/ns3:fridayWeek4) &gt; 0">
							<xsl:value-of select='format-number(m1:seriesLevelInfo/m1:netAssetValue/ns3:fridayWeek4, "$#,##0.0000")' />
						</xsl:if>
					</div>									
				</td>
			</tr>
			<tr>
				<td class="label">
					<blockquote>
						v. Friday, week 5 (if applicable):
					</blockquote>
				</td>
				<td>
					<div class="fakeBox2">
						<xsl:if test="string(m1:seriesLevelInfo/m1:netAssetValue/ns3:fridayWeek5) &gt; -10000">
							<xsl:value-of select='format-number(m1:seriesLevelInfo/m1:netAssetValue/ns3:fridayWeek5, "$#,##0.0000")' />
						</xsl:if>
					</div>									
				</td>
			</tr>
		</table>
	</xsl:template>
</xsl:stylesheet>

